; (*| 14:58 21/11/1991 *)
TITLE	FPRINT
PAGE	60,78

LF	EQU	0AH
CR	EQU	0DH
;
DOSD_READ	EQU  2		; Disk sector read
;
DOSF_CONOUT	EQU  2		; Console output
DOSF_DRCIO	EQU  6		; Direct console I/O
DOSF_OUTSTR	EQU  9		; Output string
DOSF_STCON	EQU 11		; Status of console
DOSF_GFATA128	EQU 28		; Get file allocation table addr
DOSF_DOSVER	EQU 48		; Get DOS Version
;
DOSF_CREAT	EQU 60
DOSF_OPENH	EQU 61		; File functions using ASCIIZ handles
DOSF_CLOSEH	EQU 62
DOSF_READH	EQU 63
DOSF_WRITEH	EQU 64
;
DOSI_DISK	EQU 13H 	; Disk functions
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_ADREAD	EQU 25H		; Absolute disk read
;
BOOTREC STRUC
	BOOT_JMP	DB	?
			DB	?
			DB	?
	OEM_NAME	DB	'12345678'
	BYTES_PER_SEC	DW	?
	SEC_PER_CLUS	DB	?
	RESERVED_SEC	DW	?
	NUM_OF_FATS	DB	?
	DIR_ENTRIES	DW	?
	SECS_IN_VOL	DW	?
	DESCRIPTOR	DB	?
	SEC_PER_FAT	DW	?
	SEC_PER_TRACK	DW	?
	NUM_OF_HEADS	DW	?
	HIDDEN_SECS	DW	?
BOOTREC ENDS
;
DIR_SIZE_OFFSET EQU	1CH	; Offset of size field in DIR entry
;
PGROUP	SEGMENT
ASSUME	CS:PGROUP,DS:PGROUP,ES:PGROUP	;
	ORG	05CH
FCB1	LABEL	BYTE
	ORG	06CH
FCB2	LABEL	BYTE
	ORG	080H
CMDSTR	LABEL	BYTE
	ORG	100H
START:	nop
	CLD
	MOV	BX,OFFSET TITMSG
	CALL	WRITELN
	MOV	DH,0			;Head 0   (0-1)
	MOV	CL,1			;Sector 1 (1-9)
	MOV	CH,0			;Track 1  (0-39)
	MOV	SI,OFFSET FCB1
	LODSB
	CMP	AL,0
	JNZ	GOT_DRV_NUM
	MOV	AL,3			;Default to C
GOT_DRV_NUM:
	DEC	AL
	MOV	BYTE PTR DRVNUM,AL
	LODSB
	CMP	AL,'?'
	JNZ	NOT_HELP
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	INT	DOSI_TERM

NOT_HELP:
	CMP	AL,'W'
	JNZ	NOT_WRITE
	MOV	BYTE PTR WRFLAG,AL
	MOV	BX,OFFSET WMSG
	CALL	WRITELN
NOT_WRITE:
	CMP	AL,'V'
	JNZ	NOT_VERIFY
	MOV	BYTE PTR VERFLAG,AL
	MOV	BX,OFFSET VMSG
	CALL	WRITELN
NOT_VERIFY:
	CMP	AL,'R'
	JNZ	NOT_RESTORE
	MOV	BYTE PTR RESFLAG,AL
	MOV	BX,OFFSET RMSG
	CALL	WRITELN
NOT_RESTORE:
	MOV	AH,DOSF_GFATA128
	MOV	DL,BYTE PTR DRVNUM	;Drive (0-3)
	INC	DL			;Drive (1-4)
	PUSH	DS
	INT	DOSI_FUNC
	MOV	AL,[BX] 		;Transfer FAT ID byte
	POP	DS
	CMP	AL,0F8H
	JZ	HARD_DISK_OK
	MOV	BX,OFFSET ABRTMSG
MSG_ABORT:
	CALL	WRITELN
	JMP	ABORT

HARD_DISK_OK:
	MOV	AH,DOSF_DOSVER
	INT	DOSI_FUNC
	CMP	AL,4
	JB	DOS3
	MOV	CX,-1
	MOV	AX,DS
	MOV	WORD PTR A_D_SEG,AX
	MOV	BX,OFFSET ADR_PARAMS
	JMP	SHORT DO_ADREAD
DOS3:
	MOV	BX,OFFSET BUFFER
	MOV	CX,1			;1 sector
DO_ADREAD:
	MOV	DX,0			;starting at first sector 
	MOV	AL,BYTE PTR DRVNUM	;Drive (0-3)
	INT	DOSI_ADREAD
	POP	CX			;Ignore PUSHF done by DOSI_ADREAD
;	ADD	SP,2			;Ignore PUSHF done by DOSI_ADREAD
	JC	DONE_DSK_PARAMS
	CALL	SET_DISK_PARAMS
DONE_DSK_PARAMS:
	MOV	AL,BYTE PTR DRVOFS
	ADD	BYTE PTR DRVNUM,AL	;add offset if hard disk
	MOV	CX,1
	MOV	SI,OFFSET FCB2+2
	MOV	DI,OFFSET SECCNT
	CALL	SET_DATA
	MOV	DI,OFFSET SECMAX
	CALL	SET_DATA
	MOV	DI,OFFSET HEADMAX
	CALL	SET_DATA
	MOV	BX,OFFSET PARTMSG
	CALL	WRITELN
	MOV	BX,OFFSET FNAME1
	CALL	OPEN_DAT_FILE
	CALL	READ_SEC		;read partition data	    
	CALL	FIND_BOOT_PART
	CALL	CLOSE_DAT_FILE
	MOV	BX,OFFSET BOOTMSG
	CALL	WRITELN
	MOV	BX,OFFSET FNAME2
	CALL	OPEN_DAT_FILE
	CALL	READ_SEC		;read boot sector of bootable part
	MOV	WORD PTR CXTEMP,CX
	CALL	SET_DISK_PARAMS
	MOV	CX,WORD PTR RESSEC
	DEC	CX
	JZ	DONE_RES
	CALL	READ_RES
DONE_RES:
	CALL	CLOSE_DAT_FILE
	CALL	READ_FATS
	CALL	READ_DIR
	CALL	READ_SYS_FILES
	nop
	nop
ABORT:
	INT	DOSI_TERM

READ_RES:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	READ_RES
	RET

READ_FATS:
	MOV	BX,OFFSET FATMSG
	CALL	WRITELN
	MOV	BX,OFFSET FNAME3
	CALL	OPEN_DAT_FILE
	XOR	CX,CX
	MOV	CL,BYTE PTR FATNUM
NEXT_FAT_BLOCK:
	PUSH	CX
	MOV	CX,WORD PTR FATSEC
NEXT_FAT_SECTOR:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	NEXT_FAT_SECTOR
	POP	CX
	LOOP	NEXT_FAT_BLOCK
	CALL	CLOSE_DAT_FILE
	RET

READ_DIR:
	MOV	BX,OFFSET DIRMSG
	CALL	WRITELN
	MOV	BX,OFFSET FNAME4
	CALL	OPEN_DAT_FILE
	CALL	CX_NEXT_SEC_READ
	CALL	CHECK_FOR_SYS_FILES
	MOV	AX,WORD PTR SBYTES
	MOV	CL,5
	ROR	AX,CL			;AX:=AX DIV 32
	MOV	CX,AX
	PUSH	DX
	MOV	AX,WORD PTR DIRCNT
	XOR	DX,DX
	DIV	CX
	MOV	CX,AX			;number of sectors for directory
	DEC	CX			;allow for first one already read
	POP	DX
NEXT_DIR_SECTOR:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	NEXT_DIR_SECTOR
	CALL	CLOSE_DAT_FILE
	RET

CHECK_FOR_SYS_FILES:
	MOV	SI,OFFSET BIOTXT
CHECK_AGAIN:
	MOV	DI,OFFSET BUFFER
	PUSH	DI
	MOV	CX,11
	CLD
	REPZ	CMPSB
	POP	DI
	JZ	CHECK_FIRST_OK
	CMP	SI,OFFSET DOSTXT
	JA	NO_SYS_MSG_ABORT
	MOV	SI,OFFSET IOTXT
	JMP	CHECK_AGAIN
CHECK_FIRST_OK:
	MOV	AX,[DI+DIR_SIZE_OFFSET]
	MOV	WORD PTR BIOSIZE,AX
	MOV	DI,OFFSET BUFFER+32
	PUSH	DI
	MOV	CX,11
	REPZ	CMPSB
	POP	DI
	JNZ	NO_SYS_MSG_ABORT
	MOV	AX,[DI+DIR_SIZE_OFFSET]
	MOV	WORD PTR DOSSIZE,AX
	RET

NO_SYS_MSG_ABORT:
	MOV	BX,OFFSET NOSMSG
	JMP	MSG_ABORT

READ_SYS_FILES:
	MOV	BX,OFFSET IBMMSG
	CALL	WRITELN
	MOV	BX,OFFSET FNAME5
	CALL	OPEN_DAT_FILE
	MOV	AX,WORD PTR BIOSIZE
	CALL	SIZE_IN_SECTORS
	MOV	CX,AX
	CALL	BALANCE_OF_CLUSTER
	PUSH	BX
NEXT_SYS_SECTOR:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	NEXT_SYS_SECTOR
	CALL	CLOSE_DAT_FILE
	POP	CX			;BX
	OR	CX,CX
	JZ	NO_BALANCE
SYS_BALANCE:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	SYS_BALANCE
NO_BALANCE:
	MOV	BX,OFFSET FNAME6
	CALL	OPEN_DAT_FILE
	MOV	AX,WORD PTR DOSSIZE
	CALL	SIZE_IN_SECTORS
	MOV	CX,AX
NEXT_DOS_SECTOR:
	PUSH	CX
	CALL	CX_NEXT_SEC_READ
	POP	CX
	LOOP	NEXT_DOS_SECTOR
	CALL	CLOSE_DAT_FILE
	RET

;SIZE IN AX, RESULT IN AX

SIZE_IN_SECTORS:
	PUSH	CX
	PUSH	DX
	XOR	DX,DX
	MOV	CX,WORD PTR SBYTES
	DIV	CX
	POP	DX
	POP	CX
	INC	AX
	RET

;SECTORS IN AX, RESULT IN BX

BALANCE_OF_CLUSTER:
	PUSH	AX
	PUSH	CX
	XOR	CX,CX
	MOV	BX,CX
	MOV	CL,BYTE PTR CLUSEC
	DIV	CL
	MOV	BL,CL
	SUB	BL,AH
	MOV	AL,CL
	DEC	AL
	AND	BL,AL
	POP	CX
	POP	AX
	RET

FIND_BOOT_PART:
	MOV	SI,OFFSET BUFFER
	ADD	SI,01BEH
	MOV	CX,4
F_B_P_LOOP:
	TEST	BYTE PTR [SI],80H	;is bootable partition if true
	JZ	F_B_P_NEXT
	CMP	BYTE PTR [SI+4],0
	JNZ	F_B_P_OK
F_B_P_NEXT:
	ADD	SI,16
	LOOP	F_B_P_LOOP
	MOV	BX,OFFSET NOMSG
	JMP	MSG_ABORT

F_B_P_OK:
	MOV	DH,BYTE PTR [SI+1]
	MOV	CX,WORD PTR [SI+2]
	RET

SET_DISK_PARAMS:
	PUSH	AX
	PUSH	SI
	MOV	SI,OFFSET BUFFER
	MOV	AX,WORD PTR [SI+BYTES_PER_SEC]
	MOV	WORD PTR SBYTES,AX
	MOV	AL,BYTE PTR [SI+SEC_PER_CLUS]
	MOV	BYTE PTR CLUSEC,AL
	MOV	AX,WORD PTR [SI+RESERVED_SEC]
	MOV	WORD PTR RESSEC,AX
	MOV	AL,BYTE PTR [SI+NUM_OF_FATS]
	MOV	BYTE PTR FATNUM,AL
	MOV	AX,WORD PTR [SI+DIR_ENTRIES]
	MOV	WORD PTR DIRCNT,AX
	MOV	AX,WORD PTR [SI+SEC_PER_FAT]
	MOV	WORD PTR FATSEC,AX
	MOV	AL,BYTE PTR [SI+SEC_PER_TRACK]
	MOV	BYTE PTR SECMAX,AL
	MOV	AL,BYTE PTR [SI+NUM_OF_HEADS]
	DEC	AL
	MOV	BYTE PTR HEADMAX,AL
	POP	SI
	POP	AX
	RET

SET_DATA:
	LODSB
	CMP	AL,'0'
	JB	NO_DATA
	AND	AL,0FH
	STOSB
NO_DATA:
	RET

; FILE NAME PASSED IN DX:BX

OPEN_DAT_FILE:
	PUSH	CX
	PUSH	DX
	MOV	DX,BX
	MOV	WORD PTR FNPTR,BX
	MOV	AL,BYTE PTR WRFLAG
	OR	AL,AL
	JZ	NOT_OPEN_WRITE
	MOV	BYTE PTR FMODE,1
	PUSH	CX
	XOR	CX,CX
	MOV	AH,DOSF_CREAT
	INT	DOSI_FUNC
	POP	CX
	JNC	END_OPEN
	JMP	SHORT BAD_OPEN

NOT_OPEN_WRITE:
	MOV	AL,BYTE PTR VERFLAG
	OR	AL,AL
	JNZ	DO_OPEN
	MOV	AL,BYTE PTR RESFLAG
	OR	AL,AL
	JZ	BAD_OPEN
DO_OPEN:
	MOV	AH,DOSF_OPENH
	MOV	AL,0			;read only access
	INT	DOSI_FUNC
	JNC	END_OPEN
	CALL	DAT_FILE_ERROR
BAD_OPEN:
	XOR	AX,AX			;set handle to 0 if error
END_OPEN:
	MOV	WORD PTR HANDLE,AX
	POP	DX
	POP	CX
	RET

PROCESS_DAT_FILE:
	PUSH	CX
	PUSH	DX
	XOR	BX,BX
	MOV	SI,BX
	MOV	DI,BX
	MOV	BX,WORD PTR HANDLE
	OR	BX,BX
	JZ	END_PROCESS
	MOV	AL,BYTE PTR FMODE
	TEST	AL,1
	JNZ	WRITE_PROCESS
	MOV	AH,DOSF_READH
	MOV	DX,OFFSET BUFFER2
	MOV	DI,DX
	MOV	SI,OFFSET BUFFER
	JMP	DO_PROCESS

WRITE_PROCESS:
	MOV	AH,DOSF_WRITEH
	MOV	DX,OFFSET BUFFER
DO_PROCESS:
	MOV	CX,WORD PTR SBYTES
	INT	DOSI_FUNC
	JNC	END_PROCESS
	CALL	DAT_FILE_ERROR
END_PROCESS:
	CMP	SI,0
	JZ	PDF_NO_VER
	MOV	CX,WORD PTR SBYTES
	REPZ	CMPSB
	JZ	PDF_NO_VER
	MOV	DX,OFFSET VERMSG
	MOV	AL,BYTE PTR RESFLAG
	OR	AL,AL
	PUSHF
	JZ	PDF_NOT_RES
	MOV	DX,OFFSET RESMSG
PDF_NOT_RES:
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POPF
	JZ	PDF_DONE
;
	NOP				;do restore here
;
PDF_DONE:
	POP	DX
	POP	CX
	CALL	SHOW_POS
	RET

PDF_NO_VER:
	POP	DX
	POP	CX
	RET

CLOSE_DAT_FILE:
	PUSH	CX
	PUSH	DX
	MOV	BX,WORD PTR HANDLE
	OR	BX,BX
	JZ	END_CLOSE
	MOV	AH,DOSF_CLOSEH
	INT	DOSI_FUNC
	XOR	AX,AX
	MOV	WORD PTR HANDLE, AX
	JNC	END_CLOSE
	CALL	DAT_FILE_ERROR
END_CLOSE:
	POP	DX
	POP	CX
	RET

;ERROR CODE IN AX

DAT_FILE_ERROR:
	PUSH	AX
	MOV	DI,OFFSET DFEDAT
	CALL	BIN_TO_ASC
	PUSH	DX
	MOV	DX,OFFSET DFEMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POP	DX
	MOV	BX,WORD PTR FNPTR
	CALL	WRITELN
	POP	AX
	RET

;INFO IN CX,DH. BX NOT PRESERVED

READ_SEC:
	MOV	BL,4
RD_SEC_LP:
	PUSH	BX
	MOV	AH,DOSD_READ
	MOV	DL,BYTE PTR DRVNUM	;Drive A: (0-3)
	MOV	AL,BYTE PTR SECCNT	;No of sectors to read
	MOV	BX,OFFSET BUFFER
	INT	DOSI_DISK
	POP	BX
	JNB	RD_SEC_OK
	DEC	BL
	JNZ	RD_SEC_LP
	PUSH	DX
	MOV	DX,OFFSET ERRMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POP	DX
	CALL	SHOW_POS
	RET

RD_SEC_OK:
	CALL	PROCESS_DAT_FILE
	RET

CX_NEXT_SEC_READ:
	MOV	CX,WORD PTR CXTEMP
	CALL	NEXT_SEC
	CALL	READ_SEC
	RET

;VARIABLES IN CX,DH. AL NOT PRESERVED

NEXT_SEC:
	MOV	AL,BYTE PTR SECCNT
	ADD	CL,AL			;Sector
	MOV	AL,CL
	AND	AL,03FH
	CMP	AL,BYTE PTR SECMAX
	JBE	NEXT_OK
	AND	CL,0C0H
	OR	CL,1
	INC	DH			;Head
	CMP	DH,BYTE PTR HEADMAX
	JBE	NEXT_OK
	MOV	DH,0		    
	INC	CH			;Track
	CMP	CH,0
	JNZ	NEXT_OK
	ADD	CL,040H
NEXT_OK:
	MOV	WORD PTR CXTEMP,CX	;save for future reference
	RET

;BIN BYTE IN AL, PTR TO RESULT WORD IN DI
        
BIN_TO_ASC:
	PUSH	CX
	MOV	AH,0
	MOV	CL,10
	DIV	CL
	ADD	AL,'0'
	ADD	AH,'0'
	STOSW
	POP	CX
	RET

BIN_TO_3ASC:
	PUSH	CX
	MOV	CL,100
	DIV	CL
	ADD	AL,'0'
	STOSB
	MOV	AL,AH
	CALL	BIN_TO_ASC
	POP	CX
	RET

; STRING PTR IN BX

WRITELN:
	PUSH	DX
	MOV	DX,BX
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	DX,OFFSET CRLFMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	POP	DX
	RET


; INFO IN CX,DH
        
SHOW_POS:
	PUSH	CX
	PUSH	DX
	PUSH	DI
	PUSHF
	MOV	AL,DH			;Head
	ADD	AL,'0'
	MOV	BYTE PTR HDNUM,AL
	MOV	AL,CL			;Sector
	AND	AL,03FH
	MOV	DI,OFFSET SECNUM
	CALL	BIN_TO_ASC
	XOR	AX,AX
	MOV	AL,CL
	AND	AL,0C0H
	ROL	AX,1
	ROL	AX,1
	MOV	AL,CH			;Track
	MOV	DI,OFFSET TRKNUM
	CALL	BIN_TO_3ASC
	MOV	DX,OFFSET TRKMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
;	 POPF
;	 PUSHF
;	 JNB	 NO_CRLF
	MOV	DX,OFFSET CRLFMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
NO_CRLF:
	POPF
	POP	DI
	POP	DX
	POP	CX
	RET    

TEST_KEY:
	PUSH	DX
	MOV	AH,DOSF_DRCIO
	MOV	DL,0FFH
	INT	DOSI_FUNC
	POP	DX
	OR	AL,AL
	RET

ADR_PARAMS:
	DD	0			;first sector
	DW	1			;1 sector
	DW	OFFSET BUFFER
A_D_SEG	DW	?

HEADMAX DB	1
SECMAX	DB	17
SECCNT	DB	1
DRVNUM	DB	0
DRVOFS	DB	07EH
SBYTES	DW	512
CLUSEC	DB	8
FATNUM	DB	2
FATSEC	DW	8
DIRCNT	DW	?
RESSEC	DW	1
CXTEMP	DW	?
BIOSIZE DW	?
DOSSIZE DW	?
WRFLAG	DB	0
RESFLAG DB	0
VERFLAG DB	0

TRKMSG	DB	'T '
TRKNUM	DB	'000'
HDMSG	DB	' H '
HDNUM	DB	'0'
SECMSG	DB	' S '
SECNUM	DB	'01 ',CR,'$'
CRLFMSG DB	CR,LF,'$'

BIOTXT	DB	'IBMBIO  COM'
DOSTXT	DB	'IBMDOS  COM'
IOTXT	DB	'IO      SYS'
MSTXT	DB	'MSDOS   SYS'
FNAME1	DB	'DISKPART.DAT',0,'$'
FNAME2	DB	'BOOTSECT.DAT',0,'$'
FNAME3	DB	'FATINFO.DAT',0,'$'
FNAME4	DB	'DIRINFO.DAT',0,'$'
FNAME5	DB	'IBMBIO.DAT',0,'$'
FNAME6	DB	'IBMDOS.DAT',0,'$'
FNPTR	DW	0
HANDLE	DW	0
FMODE	DB	0
TITMSG	DB	'Hard Disk Fingerprint Program by B Whitnall. V1.1$'
HLPMSG	DB	'Usage : FPRINT [Drive:][R][V][W]',CR,LF
	DB	'    R : Restore copied sectors',CR,LF
	DB	'    V : Verify copied sectors',CR,LF
	DB	'    W : Write copies of sectors',CR,LF
	DB	' Defaults: ',CR,LF,'$'
WMSG	DB	'Making copies$'
VMSG	DB	'Verifying$'
RMSG	DB	'Restoring$'
PARTMSG DB	'Partition Sector$'
BOOTMSG DB	'Boot Sectors$'
FATMSG	DB	'FAT Sectors$'
DIRMSG	DB	'Dir Sectors$'
IBMMSG	DB	'System Files Sectors$'
ABRTMSG DB	'Cannot test floppy disk, program aborted$'
NOMSG	DB	'No bootable partitions$'
NOSMSG	DB	'No system$'
VERMSG	DB	'Verification error at $'
RESMSG	DB	'Y/N ? Restore at $'
ERRMSG	DB	'Error reading $'
DFEMSG	DB	'Error '
DFEDAT	DB	'  '
	DB	' with file $'

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - START

IF	SPAN MOD 256
	ORG	(THIS_SITE + 256) - (SPAN MOD 256)
ENDIF

BUFFER:
	DB	512 DUP(?)
BUFFER2:
	DB	512 DUP(?)

PGROUP	ENDS
END	START
